<?PHP
// Version 0.9 (c) 2001
// Version 1.9 (c) 2001
//              - Vincent Houwert (vincent@trueserver.nl)
//              - Marcel Leicher (marcel@silverpoint.nl)
//   LAST UPDATE: 10/06/2001

// ############################### User settings ############################### //

// remove the slashes if you would like to use a default background image. Place it in /img/.
// i.e. for /home/www/mrtg/img/mycompany.png set baseimg to 'mycompany'.
//$baseimg = '';

// you can give the bars your own color, these are rgb settings.
//$red = '100'; $green = '100'; $blue = '100';

// It should not be neccesary to edit anything below here.

// ############################### VASTE GEGEVENS EN FUNCTIES ############################### //
if ($debug) { echo "Debug mode = on.<p>"; };

$bytesformat = array(
		"id" => array (0, 1, 2, 3, 4, 5),
		"short" => array ("B", "KB", "MB", "GB", "TB", "PB"), 
		"long" => array ("Bytes", "KiloBytes", "MegaBytes", "GigaBytes", "TeraBytes", "PetaBytes")
		);

$maanden = array(1=>"January", "Februari", "March", "April", "May", "June", "July", "August", "September", "Oktober", "November", "December");

// Day in Month
$maand = ($month?$month:date("n"));
if (strlen($maand)!='2') { $maanda = '0'.$maand; } else { $maanda = $maand; };
$jaar = ($year?$year:date("Y"));
//$dim = mcal_days_in_month($maand, $year);
$dim = strftime ("%d", mktime (0,0,0,$maand+1,0,$jaar));
if ($debug) { echo "De maand ".$maand." in ".$jaar." heeft ".$dim." dagen.<p>"; };

function formatBytes($waarde, $weergave) {
	// bij weergaven is 0 als int terug geven, short=korte notatie en long=lange notatie
	// nog een keer in de fuctie (waarom)
	$bytesformat = array(
		"id" => array (0, 1, 2, 3, 4, 5),
		"short" => array ("B", "KB", "MB", "GB", "TB", "PB"), 
		"long" => array ("Bytes", "KiloBytes", "MegaBytes", "GigaBytes", "TeraBytes", "PetaBytes"),
		"fakt" => array (0, 1, 2, 3, 4, 5)
		);
	if     ($waarde/1024/1024/1024/1024/1024 > 1)	{ 
		$waarde = sprintf("%0.2f",$waarde/1024/1024/1024/1024/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][5];
		};
	}
	elseif ($waarde/1024/1024/1024/1024 > 1)  		{ 
		$waarde = sprintf("%0.2f",$waarde/1024/1024/1024/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][4];
		};
	}
	elseif ($waarde/1024/1024/1024 > 1)  			{ 
		$waarde = sprintf("%0.1f",$waarde/1024/1024/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][3];
		};
	}
	elseif ($waarde/1024/1024 > 1)   				{ 
		$waarde = sprintf("%0.1f",$waarde/1024/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][2];
		};
	}
	elseif ($waarde/1024 > 1)    					{ 
		$waarde = sprintf("%0.1f",$waarde/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][1]; 
		};
	}
	else	                    					{ 
		$waarde = sprintf("%0.1f",$waarde);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][0]; 
		};
	};
	return $waarde;
};

// ############################### MAIN PROGRAM ############################### //
// begin met een basis plaatje
if ($baseimg) {
	$im = ImageCreateFromPng("img/".$baseimg.".png");
	// Kleuren:
	if (!$red) { 
		$grc = ImageColorAllocate($im, 0, 200, 0); 
		$grc2 = ImageColorAllocate($im, 0, 220, 0); 
	} else { 
		$grc = ImageColorAllocate($im, $red, $green, $blue); 
	};
	$tc = ImageColorAllocate ($im, 0, 0, 0);
	$avgc = ImageColorAllocate ($im, 0, 0, 200); 
	$grijs = ImageColorAllocate ($im, 180, 180, 180);
} else {
	$y = 170;
	$x = 500;
	$im = ImageCreate($x, $y);
	$wit = ImageColorAllocate ($im, 250, 250, 250);
	$up = ImageColorAllocate ($im, 200,200,200);
	$down = ImageColorAllocate ($im, 100,100,100);
	$tc = ImageColorAllocate ($im, 0,0,0);
	ImageFill ($im, 0, 0, $wit);
	$bot = $y-1;
	$bot2 = $y-2;
	$bot3 = $y-3;
	$rig = $x-1;
	$rig2 = $x-2;
	$rig3 = $x-3;
	ImageLine ($im, 0,0,0,$bot, $up);
	ImageLine ($im, 1,1,1,$bot2, $up);
	ImageLine ($im, 0,0,$rig,0, $up);
	ImageLine ($im, 1,1,$rig2,1, $up);
	ImageLine ($im, $rig,0,$rig,$bot,$down);
	ImageLine ($im, $rig2,1,$rig2,$bot2,$down);
	ImageLine ($im, 0,$bot,$rig,$bot,$down);
	ImageLine ($im, 1,$bot2,$rig2,$bot2,$down);
	ImageLine ($im, 79, 14, ($dim=='31'?'488':'483'), 14, $tc);
	ImageLine ($im, 79, 39, ($dim=='31'?'488':'483'), 39, $tc);
	ImageLine ($im, 79, 64, ($dim=='31'?'488':'483'), 64, $tc);
	ImageLine ($im, 79, 89, ($dim=='31'?'488':'483'), 89, $tc);
	// Kleuren:
	if (!$red) { 
		$grc = ImageColorAllocate($im, 0, 200, 0); 
		$grc2 = ImageColorAllocate($im, 0, 220, 0); 
	} else { 
		$grc = ImageColorAllocate($im, $red, $green, $blue); 
	};
	$tc = ImageColorAllocate ($im, 0, 0, 0);
	$avgc = ImageColorAllocate ($im, 0, 0, 200); 
	$grijs = ImageColorAllocate ($im, 180, 180, 180);
	for ($j=82; $j<485; $j++) {
	   ImageLine ($im, $j, 15, $j, 113, $wit);
	   $j++;
	   ImageLine ($im, $j, 15, $j, 113, $wit);
	   $j++;
	}
	ImageLine ($im, 79, 114, 488, 114, $tc);
	ImageRectangle ($im, 81, 14, 486, 114, $tc);
	ImageString ($im, 2, 41, 108, "0.0", $tc);
};

// file opzoeken in in array dumpen
if ($debug) { echo "Document root currently: ".$DOCUMENT_ROOT."<br>"; };
if (file_exists($DOCUMENT_ROOT."/".$host.".data")) {
	$rawdata = file($DOCUMENT_ROOT."/".$host.".data");
	if ($debug) { echo "Parsed file: <u>".$DOCUMENT_ROOT."/".$host.".data</u><p>"; };
} else {
	ImageString ($im, 2,  160, 50, "Data file currently not available at", $tc);
	ImageString ($im, 2,  90, 67, "at ".$DOCUMENT_ROOT."/".$host.".data.", $tc);
	$error = "File ".$DOCUMENT_ROOT."/".$host.".data does not exists, exiting";
};

// array opschonen, hoogste bepalen
$k=0;
for ($j=0; $j<count($rawdata); $j++) {
	$tmp = explode("\t", $rawdata[$j]);
	if (substr(trim($tmp[0]),0,6)==$jaar.$maanda) {
		$data["datum"][$k] = trim($tmp[0]);
		$data["bytes"][$k] = trim(str_replace("\n","",$tmp[1]));
		if ($data["bytes"][$k]>$hoogst[1]) {
			$hoogst[0] = $data["datum"][$k];
			$hoogst[1] = $data["bytes"][$k];
		};
		if ($debug) { echo "Grafiekwaarde ".$data["datum"][$k].": ".$data["bytes"][$k]."<br>"; };
		$k++;
	};
};
if ($debug) { echo "<br><b>Max. value found op ".$hoogst[0].": ".formatBytes($hoogst[1],long)." (".round($hoogst[1])." bytes).</b><p>"; };

if (!$data || $hoogst[1]=='0' || $error) { 
	ImageString ($im, 2, 23,  8, "   4.0", $tc);
	ImageString ($im, 2, 23, 33, "   3.0", $tc);
	ImageString ($im, 2, 23, 58, "   2.0", $tc);
	ImageString ($im, 2, 23, 83, "   1.0", $tc);
	ImageStringUP ($im, 2, 7, 115, "bytes per day", $tc);
	ImageString ($im, 2,  10, 134, "Total ".$maanden[$maand]." ".$jaar.":", $tc);
	ImageString ($im, 2, 180, 134, "0 bytes", $tc);
	ImageString ($im, 2,  10, 149, "Expected ".$maanden[$maand]." ".$jaar.":", $tc);
	ImageString ($im, 2, 180, 149, "0 bytes", $tc);
	ImageString ($im, 2, 260, 134, "Average ".$maanden[$maand]." ".$jaar.":", $avgc);
	ImageString ($im, 2, 410, 134, "0 bytes/day", $tc);
	ImageString ($im, 2, 260, 149, "Peak ".$maanden[$maand]." ".$jaar.":", $tc);
	ImageString ($im, 2, 410, 149, "0 bytes", $tc);
	// Text (dagen):
	$x1=96;
	$index=2;
	for ($i=0; $i<$dim-1; $i+=2) {
		if (strlen($index)<2) { $index = " ".$index; };
		ImageString ($im, 2, $x1, 117, $index, $tc);
		$x1+=26;
		$index=trim($index)+2;
	};
	} else {
	// find the maxY en define the minY
	$maxY = ceil(formatBytes($hoogst[1],0));
	while ($maxY%2 != 0) { 
		$maxY+=1; 
	};
	$minY = $maxY/4;
	if ($debug) { echo "Plavond: ".$maxY.". Bodem van de pizza: ".$minY."<br>"; };
	
	// y waardes format
	$Yv1 = sprintf("%0.1f",$maxY);
	while(strlen($Yv1)<6) {
		$Yv1 = ' '.$Yv1;
	};
	$Yv2 = sprintf("%0.1f",round($minY*3,1));
	while(strlen($Yv2)<6) {
		$Yv2 = ' '.$Yv2;
	};
	$Yv3 = sprintf("%0.1f",round($minY*2,1));
	while(strlen($Yv3)<6) {
		$Yv3 = ' '.$Yv3;
	};
	$Yv4 = sprintf("%0.1f",round($minY,1));
	while(strlen($Yv4)<6) {
		$Yv4 = ' '.$Yv4;
	};

	// Text (aantal bytes):
	ImageString ($im, 2, 23, 8, $Yv1, $tc);
	ImageString ($im, 2, 23, 33, $Yv2, $tc);
	ImageString ($im, 2, 23, 58, $Yv3, $tc);
	ImageString ($im, 2, 23, 83, $Yv4, $tc);
	// Text (links):
	$tmp = split(" ",formatBytes($hoogst[1],"long"));
	$ytext = trim($tmp[1]);
	ImageStringUP ($im, 2, 7, 115, $ytext." per day", $tc);
	
	// totaal en gemiddelde bepalen
	$tot = array_sum($data["bytes"]);
	$avg = $tot/count(array_values($data["datum"]));
	if ($debug) { echo "Het totaal aantal is ".$tot." (netjes: ".formatBytes($tot,"short").") met een gemiddelde van ".formatBytes($avg,"short")." op ".count(array_values($data["datum"]))." dagen.<p>"; };
	
	$Ymax = "17";
	$Ymin = "112";
	$Diff = $Ymin-$Ymax;
	// $PpG = $Diff/$hoogst[1];
	$ppb = $Diff/$maxY; // pixel per Gigabyte, (c) vincent :) en ik verzon ppb, pixels per byte
	if ($debug) { echo "De ppb waarde is: ".$ppb." omdat ".$Diff."/".$maxY." dat is.<p>"; };

	$formaat = substr(formatBytes($hoogst[1],"short"),-2);
	//"B", "KB", "MB", "GB", "TB", "PB"
	if     ($formaat == "PB") { $deelfakt = 1/1024/1024/1024/1024/1024; }
	elseif ($formaat == "TB") { $deelfakt = 1/1024/1024/1024/1024; }
	elseif ($formaat == "GB") { $deelfakt = 1/1024/1024/1024; }
	elseif ($formaat == "MB") { $deelfakt = 1/1024/1024; }
	elseif ($formaat == "KB") { $deelfakt = 1/1024; }
	else { $deelfakt = 1; };
	if ($debug) { echo "Gevonden max format: ".$formaat." en we gaan delen met ".$deelfakt."<br>"; };
	for ($i=0; $i<count(array_values($data["datum"])); $i++) {
		$perdag[$i] = 112-(($data["bytes"][$i]*$deelfakt)*$ppb);
		if ($debug) { echo "Op dag ".$i." (".$data["datum"][$i]."): ".$perdag[$i]."<br>"; };
	};
	
	$AVG = $Ymin-formatBytes($avg,0)*$ppb;
		
	// Text (dagen):
	$x1=96;
	$index=2;
	for ($i=0; $i<$dim-1; $i+=2) {
		if (strlen($index)<2) { $index = " ".$index; };
		ImageString ($im, 2, $x1, 117, $index, $tc);
		$x1+=26;
		$index=trim($index)+2;
	};
	
	// Palen:
	$x1=83;
	for ($i=0;$i<count($perdag); $i++) {
		if ($perdag[$i]!='112') { ImageFilledRectangle ($im, $x1, $perdag[$i], $x1+11, $Ymin, ($i%2==1?$grc2:$grc)); };
		$x1=$x1+13;
	};
	
	// Gemiddelde-lijn:
	ImageLine ($im, 83, $AVG, 484, $AVG, $avgc);
	
	// Finishing touch:
	//ImageRectangle ($im, 80, 14, 488, 114, $tc);
	//ImageLine ($im, 2, 137, 497, 137, $tc);
	// strings even lang maken linker unit
	$expthismonth = formatBytes($avg*$dim,"short");
	$thismonth =    formatBytes($tot,"short");
	while (strlen($expthismonth)>strlen($thismonth)) {
		$thismonth = ' '.$thismonth;
	};
	$avg = formatBytes($avg,"short");
	$peak = formatBytes($hoogst[1],"short");
	while (strlen($peak)>strlen($avg)) {
		$avg = ' '.$avg;
	};
	ImageString ($im, 2,  10, 134, "Total ".$maanden[$maand]." ".$jaar.":", $tc);
	ImageString ($im, 2, 180, 134, $thismonth, $tc);
	if ($month==date("n")) {
	ImageString ($im, 2,  10, 149, "Expected ".$maanden[$maand]." ".$jaar.":", $tc);
	ImageString ($im, 2, 180, 149, $expthismonth, $tc);
	};
	ImageString ($im, 2, 260, 134, "Average ".$maanden[$maand]." ".$jaar.":", $avgc);
	ImageString ($im, 2, 410, 134, $avg."/day", $tc);
	ImageString ($im, 2, 260, 149, "Peak ".(substr($hoogst[0],6,1)==0?substr($hoogst[0],7,1):substr($hoogst[0],6,2))." ".$maanden[$maand]." ".$jaar.":", $tc);
	ImageString ($im, 2, 410, 149, $peak."/day", $tc);
};	

// Uitspugen die zooi:
if (!$debug) {
	Header("Content-type: image/png");
	ImagePng($im);
};

?>
