#include "precompiled.h"

/*
 * wxJavaScript - split.cpp
 *
 * Copyright (c) 2002-2007 Franky Braem and the wxJavaScript project
 *
 * Project Info: http://www.wxjavascript.net or http://wxjs.sourceforge.net
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * $Id$
 */

#ifndef WX_PRECOMP
	#include <wx/wx.h>
#endif

#include "../../common/main.h"
#include "../../common/apiwrap.h"

#include "jsevent.h"
#include "split.h"

using namespace wxjs;
using namespace wxjs::gui;

/***
 * <file>event/split</file>
 * <module>gui</module>
 * <class name="wxSplitterEvent" prototype="@wxNotifyEvent">
 *	This class represents the events generated by a @wxSplitterWindow.
 * </class>
 */
WXJS_INIT_CLASS(SplitterEvent, "wxSplitterEvent", 0)

/***
 * <properties>
 *	<property name="sashPosition" type="Integer">
 *   Returns the new sash position.
 *  </property>
 *	<property name="x" type="Integer" readonly="Y">
 *   Returns the x coordinate of the double-click point.
 *  </property>
 *	<property name="y" type="Integer" readonly="Y">
 *   Returns the y coordinate of the double-click point.
 *  </property>
 *	<property name="windowBeingRemoved" type="@wxWindow" readonly="Y">
 *   Returns the window being removed when a splitter window is unsplit. 
 *  </property>
 * </properties>
 */
WXJS_BEGIN_PROPERTY_MAP(SplitterEvent)
	WXJS_PROPERTY(P_SASH_POSITION, "sashPosition")
	WXJS_READONLY_PROPERTY(P_X, "x")
	WXJS_READONLY_PROPERTY(P_Y, "y")
	WXJS_READONLY_PROPERTY(P_WINDOW_BEING_REMOVED, "windowBeingRemoved")
WXJS_END_PROPERTY_MAP()

bool SplitterEvent::GetProperty(PrivSplitterEvent* p,
                                JSContext* cx,
                                JSObject* WXUNUSED(obj),
                                int id,
                                jsval* vp)
{
    wxSplitterEvent *event = p->GetEvent();

	switch(id)
    {
    case P_SASH_POSITION:
	  {
		 *vp = ToJS(cx, event->GetSashPosition());
         break;
	  }
    case P_X:
	  {
		 *vp = ToJS(cx, event->GetX());
         break;
	  }
    case P_Y:
	  {
		 *vp = ToJS(cx, event->GetY());
         break;
	  }
    case P_WINDOW_BEING_REMOVED:
      {
	    wxWindow *win = event->GetWindowBeingRemoved();
        if ( win == NULL )
        {
          *vp = JSVAL_VOID;
        }
        else
        {
          JavaScriptClientData *data 
              = dynamic_cast<JavaScriptClientData*>(win->GetClientObject());
          *vp = ( data == NULL ) ? JSVAL_VOID 
                                 : OBJECT_TO_JSVAL(data->GetObject());
        }
        break;
      }
    }
	return true;
}

bool SplitterEvent::SetProperty(PrivSplitterEvent* p,
                                JSContext* cx,
                                JSObject* WXUNUSED(obj),
                                int id,
                                jsval* vp)
{
    wxSplitterEvent *event = p->GetEvent();

	switch(id)
    {
    case P_SASH_POSITION:
	  {
        int pos;
        if ( FromJS(cx, *vp, pos) )
        {
          event->SetSashPosition(pos);
        }
         break;
	  }
    }
	return true;
}
